<?php
/*
GameBoss plugin class
http://DeveloperGuru.NET
*/ 

define("PARTNER_ID", "gb_dg_partnerId", true);
define("IS_PUBLISH", "gb_dg_isPublish", true);
define("IS_UPDATE_EXISTING", "gb_dg_isUpdateExisting", true);
define("GENRES", "gb_dg_genres", true);

set_time_limit( 0 );

require_once( ABSPATH."/wp-includes/class-snoopy.php" );
require_once( ABSPATH."/wp-includes/formatting.php" );
require_once("gameitem.class.php");
require_once(ABSPATH."/wp-content/plugins/rus-to-lat/functions.php");

class maxsite_plugin_base 
{

	var $page_title;
	var $menu_title;
	var $access_level;
	var $add_page_to; // 1=add_menu_page 2=add_options_page 3=add_theme_page 4=add_management_page 
	var $short_description;
	
	function maxsite_plugin_base() 
	{
		$this->get_options();
	}
	
	function get_options()
	{
	
	}
	
	function add_admin_menu() 
	{
		if ( $this->add_page_to == 1 )
			add_menu_page($this->page_title, $this->menu_title, $this->access_level, __FILE__, array($this, 'admin_page'));
		elseif ( $this->add_page_to == 2 )
			add_options_page($this->page_title, $this->menu_title, $this->access_level, __FILE__, array($this, 'admin_page'));
		elseif ( $this->add_page_to == 3 )
			add_management_page($this->page_title, $this->menu_title, $this->access_level, __FILE__, array($this, 'admin_page'));			
		elseif ( $this->add_page_to == 4 )
			add_theme_page($this->page_title, $this->menu_title, $this->access_level, __FILE__, array($this, 'admin_page'));
	}


	function activate() 
	{ 
		add_option(PARTNER_ID,"32338");
	}


	function deactivate() 
	{ 
		delete_option(PARTNER_ID);
	}


	function admin_page() 
	{ 
		echo <<<EOF
		<div class="wrap"> 
		<h2>{$this->page_title}</h2>
		<p>{$this->short_description}</p>
EOF;

		if (isset($_REQUEST['UPDATE']) || isset($_REQUEST['IMPORT'])) 
		{ 
		
			echo "<div class='updated'>Опции сохранены!</div><p>"; 
			
			update_option(PARTNER_ID, $_REQUEST['partnerId']);
			update_option(IS_PUBLISH, (!empty($_REQUEST['isPublish']) ? true : false));
			update_option(IS_UPDATE_EXISTING, (!empty($_REQUEST['isUpdateExisting']) ? true : false));
			
			$genres[0] = (isset($_REQUEST['genres1'])) ? $_REQUEST['genres1'] : 0;
			$genres[1] = (isset($_REQUEST['genres2'])) ? $_REQUEST['genres2'] : 0;
			$genres[2] = (isset($_REQUEST['genres3'])) ? $_REQUEST['genres3'] : 0;
			$genres[3] = (isset($_REQUEST['genres4'])) ? $_REQUEST['genres4'] : 0;
			update_option(GENRES, serialize($genres));
			
			echo '</p>';

		} // ### обновление
		
		if(isset($_REQUEST['IMPORT']))
		{
			echo "<div class='updated'>Игры импортированы!</div><p>"; 
			$this->ProcessXml();
		}

		$this->view_options_page();
		
		echo '</div>';
	}



	function view_options_page() 
	{ 
		$partnerId = get_option(PARTNER_ID);
		$isPublish = (get_option(IS_PUBLISH) ? "checked" : "");
		$isUpdateExisting = (get_option(IS_UPDATE_EXISTING) ? "checked" : "");
		$genres = unserialize(get_option(GENRES));
		
		require_once( "plugin.html.php" );

	}
	
	function GetXml()
	{
		$snoopy = new Snoopy();
		$partnerId = get_option(PARTNER_ID);
		$xmlUrl = "http://gameboss.ru/engine/guest.xml?stype=19&id=&search=&ip=&purchase=$partnerId&page=0&pp=1000";
		$snoopy->fetch( $xmlUrl );
		return $snoopy->results;
	}

	function ProcessXml()
	{
		global $wpdb;
		
		$isPublish = get_option(IS_PUBLISH);
		$isUpdateExisting = get_option(IS_UPDATE_EXISTING);
		$genres = unserialize(get_option(GENRES));
		
		$xmlString = $this->GetXml();
		if( strlen( $xmlString ) == 0 )
		{
			return "Ошибка получения XML.";
		}
		$xml = simplexml_load_string( $xmlString );
		//$xml =  simplexml_load_file(ABSPATH."wp-content/plugins/gameboss-developerguru.net/gameboss.xml");
		
		foreach($xml->result->ITEM as $item)
		{
			$gameItem = new GameItem($item);
			
			$metaSql = "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'ITEM_ID' AND meta_value='".$gameItem->getId()."'";
			$metaResults = $wpdb->get_results($metaSql);
			$postId = $metaResults[0]->post_id;
			if(isset($postId) && !$isUpdateExisting)
			{
				// Game already exists - skip
				continue;
			}
			
			$postSql = "SELECT post_content, post_status FROM $wpdb->posts WHERE ID = $postId";
			$postResults = $wpdb->get_results($postSql);
			$postContent = $postResults[0]->post_content;
			$postStatus = ($isPublish) ? "publish" : "draft";
			if(isset($postId))
			{
				$postStatus = $postResults[0]->post_status;
			}
			
			// Set categories by genres
			$catArray = array();
			if(isset($postId))
			{
				$catArray = wp_get_post_categories($postId);
			}
			foreach($gameItem->getGenreArray() as $g)
			{
				$catArray[] = $genres[$g - 1];
			}
			
			echo "<strong>" . $item->NAME . "</strong> импортирована ";
			echo "(GameBossId=" . $gameItem->getId() . "; PostId=" . $postId.")<br>";
			flush();
			
					
			$postarr = array( 
				"ID" => $postId
				, "post_content" => $gameItem->getContent($postContent)
				, "post_title" => $item->NAME
				, "post_excerpt" => $item->SHORTDESCR
				, "post_name" => $gameItem->getPostUrl()
				, "post_status" => $postStatus
				, "post_category" => $catArray
				// , "post_modified" => $postDate
				// , "post_modified_gmt" => $postDate
				, "post_date" => $gameItem->getAddedDate()
				, "post_date_gmt" => $gameItem->getAddedDate()
			);
			
			$postId = wp_update_post($postarr);
			if ( update_post_meta( $postId, "ITEM_ID", $gameItem->getId() ) === false )
			{
				add_post_meta( $postId, "ITEM_ID", $gameItem->getId() );
			}
			// Title for All-in-One-SEO
			if ( update_post_meta( $postId, "title", $gameItem->getPostTitle() ) === false )
			{
				add_post_meta( $postId, "title", $gameItem->getPostTitle() );
			}
		}
	}
		



} // class maxsite_plugin_base


?>