<?php
/*
GameBoss plugin class
http://DeveloperGuru.NET
*/ 

class GameItem
{
	private $content;
	private $screenshots;
	
	function __construct($item)
	{
		require( "template.php" );
			
		$this->id = strip_tags($item->ID[0]->asXML());
		$this->nameUrl = strip_tags($item->NAME_URL[0]->asXML());
		$this->name = strip_tags($item->NAME[0]->asXML());
		$this->fullDescription = strip_tags($item->FULLDESCR[0]->asXML());
		$this->mediumLogo = strip_tags($item->MEDIUM_PIC[0]->asXML());
		$this->downloadLink = strip_tags($item->DOWNLOAD_LINK[0]->asXML());
		$this->size = strip_tags($item->SIZE[0]->asXML());
		$this->genreArray = split(",", strip_tags($item->TYPE[0]->asXML()));
		$this->addedDate = strip_tags($item->ADDED[0]->asXML());

		$i = 0;
		foreach($item->SCREENSHOT as $screenshot)
		{
			$screenshotArray[i] = new Screenshot($screenshot);
			$this->screenshots .= $screenshotArray[i]->getContent();
		}
		$this->content = $this->ReplaceTemplateString($postTemplate);
		$this->postTitle = $this->ReplaceTemplateString($postTitleTemplate);
	}
	
	function getContent($postContent)
	{
		if(isset($postContent))
		{
			if(preg_match("/<!-- description -->(.*)<!-- description -->/s", $postContent, $postRegexp))
			{
				$description = $postRegexp[1];
				
				$this->content = preg_replace(
					"/<!-- description -->(.*)<!-- description -->/s"
					, "<!-- description -->".$description."<!-- description -->"
					, $this->content
				);
			}
			else
			{
				// No <!-- description --> tag. So return post content.
				return $postContent;
			}
		}
		return $this->content;
	}
	
	// private function GetDescriptionFromContent($postContent)
	// {
		// if(preg_match( "<!-- description -->(.*)<!-- description -->", $post[0]->$postContent, $regexp ) )
		// {
			// $description = $regexp[1];
		// }
		// else
		// {
			// $description = strip_tags( $post[0]->post_content );
		// }
	// }

	private $id;
	function setId($id)
	{
		$this->id = $id;
	}
	function getId()
	{
		return $this->id;
	}

	private $nameUrl;
	function setNameUrl($nameUrl)
	{
		$this->nameUrl = $nameUrl;
	}
	function getNameUrl()
	{
		return $this->nameUrl;
	}

	private $name;
	function setName($name)
	{
		$this->name = $name;
	}
	function getName()
	{
		return $this->name;
	}

	private $fullDescription;
	function getFullDescription()
	{
		return $this->fullDescription;
	}

	private $mediumLogo;
	function getMediumLogo()
	{
		return $this->mediumLogo;
	}

	private $downloadLink;
	function getDownloadLink()
	{
		return $this->downloadLink;
	}

	private $size;
	function getSize()
	{
		return round($this->size / 1000, 2);
	}

	private $screenshotImage;
	function getScreenshotImage()
	{
		return $this->screenshotImage;
	}

	private $screenshotThumbnail;
	function getScreenshotThumbnail()
	{
		return $this->screenshotThumbnail;
	}

	private $genreArray;
	function setGenreArray($genreArray)
	{
		$this->genreArray = $genreArray;
	}
	function getGenreArray()
	{
		return $this->genreArray;
	}

	private $addedDate;
	function setAddedDate($addedDate)
	{
		$this->addedDate = $addedDate;
	}
	function getAddedDate()
	{
		return $this->addedDate;
	}
	
	function getPostUrl()
	{
		// $postUrl = str_ireplace(" ", "-", sanitize_title_with_translit(mb_strtolower($this->getName(), "UTF-8")));
		// $postUrl = preg_replace('/&.,+?;/', '', $postUrl); 
		// return $postUrl;
		return sanitize_title($this->getName());
	}
	
	private $postTitle;
	function getPostTitle()
	{
		return $this->postTitle;
	}

	
	private function ReplaceTemplateString( $templateString )
	{
		$templateString = str_ireplace( "%SCREEN_SHOT_TEMPLATE%", $this->screenshots, $templateString );

		$templateString = str_ireplace( "%ID%", $this->getId(), $templateString );
		$templateString = str_ireplace( "%NAME_URL%", $this->getNameUrl(), $templateString );
		$templateString = str_ireplace( "%NAME%", $this->getName(), $templateString );
		$templateString = str_ireplace( "%POST_URL%", $this->getPostUrl(), $templateString );
		$templateString = str_ireplace( "%FULLDESCR%", "<!-- description -->\n".$this->getFullDescription()."\n<!-- description -->", $templateString );
		$templateString = str_ireplace( "%MEDIUM_PIC%", $this->getMediumLogo(), $templateString );
		$templateString = str_ireplace( "%DOWNLOAD_LINK%", $this->getDownloadLink(), $templateString );
		$templateString = str_ireplace( "%SIZE%", $this->getSize(), $templateString );
		

	    return $templateString;
	}

	
	
}

class Screenshot
{
	private $content;
	
	function __construct($screenshot)
	{
		$this->image = strip_tags($screenshot->IMAGE[0]->asXML());
		$this->thumbnail = strip_tags($screenshot->THUMBNAIL[0]->asXML());

		require( "template.php" );
		$this->content = $this->ReplaceTemplateString($screenshotTemplate);
			
	}

	function getContent()
	{
		return $this->content;
	}

	private $image;
	function getImage()
	{
		return $this->image;
	}

	private $thumbnail;
	function getThumbnail()
	{
		return $this->thumbnail;
	}

	private function ReplaceTemplateString( $templateString )
	{
		// SCREENSHOT
		$templateString = str_ireplace( "%IMAGE%", $this->getImage(), $templateString );
		$templateString = str_ireplace( "%THUMBNAIL%", $this->getThumbnail(), $templateString );

	    return $templateString;
	}

}

?>