<?php
/*
Plugin Name: RusToLat
Plugin URI: http://mywordpress.ru/plugins/rustolat/
Description: Транслитерация русских символов URL в английские. Thanks to Alexander Shilyaev for idea. Send your suggestions and critics to <a href="mailto:skorobogatov@gmail.com">skorobogatov@gmail.com</a>.
Author: Anton Skorobogatov <skorobogatov@gmail.com>
Contributor: Andrey Serebryakov <saahov@gmail.com>
Author URI: http://skorobogatov.ru/
Version: 0.3
*/ 

require_once("functions.php");
  
function rtl_options_page() {
?>
<div class="wrap">
	<h2>Настройки RusToLat</h2>
	<p>Вы можете выбрать стандарт, по которому будет производится транслитерация заголовков.</p>
	<?php
	if($_POST['rtl_standard']) {
		// set the post formatting options
		update_option('rtl_standard', $_POST['rtl_standard']);
		echo '<div class="updated"><p>Настройки обновлены.</p></div>';
	}
	?>

	<form method="post">
	<fieldset class="options">
		<legend>Производить транслитерацию в стандарте:</legend>
		<?php
		$rtl_standard = get_option('rtl_standard');
		?>
			<select name="rtl_standard">
				<option value="off"<?php if($rtl_standard == 'off'){ echo(' selected="selected"');}?>>Отключена</option>
				<option value="gost"<?php if($rtl_standard == 'gost'){ echo(' selected="selected"');}?>>ГОСТ 16876-71</option>
        <option value="iso"<?php if($rtl_standard == 'iso' OR $rtl_standard == ''){ echo(' selected="selected"');}?>>ISO 9-95</option>        								
			</select>

			<input type="submit" value="Изменить стандарт" />

	</fieldset>
	</form>
</div>
<?php
}

function rtl_add_menu() {
		add_options_page('RusToLat', 'RusToLat', 8, __FILE__, 'rtl_options_page');
}

add_action('admin_menu', 'rtl_add_menu');
add_action('sanitize_title', 'sanitize_title_with_translit', 0);
?>